<?php
/**
 * @package  : OMGF
 * @author   : Daan van den Bergh
 * @copyright: (c) 2019 Daan van den Bergh
 * @url      : https://daan.dev
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

require_once(dirname(dirname(__FILE__)) . '/class-ajax.php');

class OMGF_AJAX_Generate_Styles extends OMGF_AJAX
{
    /** @var array $fonts */
    private $fonts = [];

    /**
     * OMGF_AJAX_Generate_Styles constructor.
     */
    public function __construct()
    {
        $this->init();
    }

    /**
     * Generate the Stylesheet
     */
    private function init()
    {
        header("Content-type: text/css");

        $this->insert_promo();

        $selectedFonts = hwlGetTotalFonts();

        $this->process_fonts($selectedFonts);

        $fonts = implode("\n", $this->fonts);
        $file  = OMGF_UPLOAD_DIR . '/' . OMGF_FILENAME;

        /**
         * If the file can be created and uploaded. Let's try to write it.
         */
        try {
            $stylesheet = fopen($file, 'w') or $this->throw_error(400, "Cannot create file {$file}");
            fwrite($stylesheet, $fonts);
            fclose($stylesheet);
            wp_die(__('Stylesheet was successfully generated and added to your theme\'s header.'));
        } catch (Exception $e) {
            $this->throw_error($e->getCode(), __("Stylesheet could not be generated: $e"));
        }
    }

    /**
     * Insert promo material :)
     *
     * The alignment is crooked, so it'll look nice in the stylesheet.
     */
    private function insert_promo()
    {
        $this->fonts[] = "/** 
 * This file is automagically generated by OMGF
 *
 * @author: Daan van den Bergh
 * @copyright: (c) 2019 Daan van den Bergh
 * @url: " . OMGF_SITE_URL . "
 */";
    }

    /**
     * Prepare fonts for generation.
     */
    private function process_fonts($fonts)
    {
        $fontDisplay = OMGF_DISPLAY_OPTION;

        foreach ($fonts as $font) {
            $fontFamily     = sanitize_text_field($font->font_family);
            $fontStyle      = sanitize_text_field($font->font_style);
            $fontWeight     = sanitize_text_field($font->font_weight);
            $fontUrlEot     = esc_url_raw($font->url_eot);
            $fontUrlWoffTwo = esc_url_raw($font->url_woff2);
            $fontUrlWoff    = esc_url_raw($font->url_woff);
            $fontUrlTtf     = esc_url_raw($font->url_ttf);
            $locals         = explode(',', sanitize_text_field($font->local));
            $fontLocal      = isset($locals[0]) ? $locals[0] : $fontFamily . " " . ucfirst($fontStyle);
            $fontLocalDash  = isset($locals[1]) ? $locals[1] : $fontFamily . "-" . ucfirst($fontStyle);

            /**
             * The alignment is crooked, so it'll look nice in the stylesheet.
             */
            $this->fonts[] = "@font-face {
    font-family: '$fontFamily';
    font-display: $fontDisplay;
    font-style: $fontStyle;
    font-weight: $fontWeight;
    src: url('$fontUrlEot'); /* IE9 Compatible */
    src: local('$fontLocal'), local('$fontLocalDash'),
         url('$fontUrlWoffTwo') format('woff2'), /* Super Modern Browsers */
         url('$fontUrlWoff') format('woff'), /* Modern Browsers */
         url('$fontUrlTtf') format('truetype'); /* Safari, Android, iOS */
    }";
        }
    }
}

new OMGF_AJAX_Generate_Styles();
